/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.level.entities.undeadminer;

import com.github.teamfusion.rottencreatures.common.registries.RCBlocks;
import com.github.teamfusion.rottencreatures.core.RottenCreatures;
import com.github.teamfusion.rottencreatures.core.data.loot.RCLootTables;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.Nullable;

public class UndeadMiner
extends Zombie {
    private static final EntityDataAccessor<Integer> DATA_VARIANT = SynchedEntityData.defineId(UndeadMiner.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public UndeadMiner(EntityType<? extends Zombie> type, Level level) {
        super(type, level);
        this.xpReward = 6;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Zombie.createAttributes().add(Attributes.SPAWN_REINFORCEMENTS_CHANCE, 0.0).add(Attributes.MAX_HEALTH, 24.0).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.ARMOR, 2.0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(2, (Goal)new RestrictSunGoal((PathfinderMob)this));
    }

    protected boolean isSunSensitive() {
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_VARIANT, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Variant", this.getVariant().getId());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setVariant(Variant.BY_ID[tag.getInt("Variant")]);
    }

    public Variant getVariant() {
        return Variant.BY_ID[(Integer)this.entityData.get(DATA_VARIANT)];
    }

    private void setVariant(Variant variant) {
        this.entityData.set(DATA_VARIANT, (Object)variant.getId());
    }

    public boolean isBaby() {
        return false;
    }

    public void setBaby(boolean baby) {
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        super.populateDefaultEquipmentSlots(random, difficulty);
        Arrays.stream(Variant.values()).filter(variant -> this.getVariant() == variant).forEach(variant -> this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)variant.getPickaxe())));
    }

    public Variant getRandomVariant(RandomSource random, Holder<Biome> biome) {
        int chance = random.nextInt(50);
        if (chance <= 15) {
            return Variant.IRON;
        }
        if (chance >= 45) {
            return Variant.DIAMOND;
        }
        if (biome.is(BiomeTags.IS_BADLANDS)) {
            return Variant.GOLD;
        }
        return Variant.STONE;
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return switch (this.getVariant().ordinal()) {
            default -> throw new MatchException(null, null);
            case 2 -> RCLootTables.UNDEAD_DIAMOND_MINER;
            case 1 -> RCLootTables.UNDEAD_IRON_MINER;
            case 0 -> RCLootTables.UNDEAD_STONE_MINER;
            case 3 -> RCLootTables.UNDEAD_GOLD_MINER;
        };
    }

    protected ItemStack getSkull() {
        return new ItemStack((ItemLike)RCBlocks.UNDEAD_MINER_HEAD.get());
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.setVariant(this.getRandomVariant(level.getRandom(), (Holder<Biome>)level.getBiome(this.blockPosition())));
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public static boolean checkUndeadMinerSpawnRules(EntityType<UndeadMiner> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return UndeadMiner.checkMonsterSpawnRules(type, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random) && (spawnType == MobSpawnType.SPAWNER || !level.canSeeSky(pos)) && pos.getY() <= (Integer)RottenCreatures.CONFIG.undeadMinerDepth.get();
    }

    public static enum Variant {
        STONE(0, "stone", Items.STONE_PICKAXE),
        IRON(1, "iron", Items.IRON_PICKAXE),
        DIAMOND(2, "diamond", Items.DIAMOND_PICKAXE),
        GOLD(3, "gold", Items.GOLDEN_PICKAXE);

        public static final Variant[] BY_ID;
        private final int id;
        private final String name;
        private final Item pickaxe;

        private Variant(int id, String name, Item pickaxe) {
            this.id = id;
            this.name = name;
            this.pickaxe = pickaxe;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public Item getPickaxe() {
            return this.pickaxe;
        }

        static {
            BY_ID = (Variant[])Arrays.stream(Variant.values()).sorted(Comparator.comparingInt(Variant::getId)).toArray(Variant[]::new);
        }
    }
}

